<?php

namespace App\Policies\sales;

use App\models\users\Role;
use App\models\users\User;
use App\models\sales\Invoice;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class InvoicePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any invoices.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the invoice.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Invoice  $invoice
     * @return mixed
     */
    public function view(User $user, Invoice $invoice)
    {
        //
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::invoice());
    }

    /**
     * Determine whether the user can create invoices.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createInvoice());
    }

    /**
     * Determine whether the user can update the invoice.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Invoice  $invoice
     * @return mixed
     */
    public function update(User $user, Invoice $invoice)
    {
        return $user->is($invoice->user);
    }

    /**
     * Determine whether the user can delete the invoice.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Invoice  $invoice
     * @return mixed
     */
    public function delete(User $user, Invoice $invoice)
    {
        //
    }

    /**
     * Determine whether the user can restore the invoice.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Invoice  $invoice
     * @return mixed
     */
    public function restore(User $user, Invoice $invoice)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the invoice.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Invoice  $invoice
     * @return mixed
     */
    public function forceDelete(User $user, Invoice $invoice)
    {
        //
    }
}
