<?php
namespace App\Policies\sales;
use App\models\users\Role;
use App\models\users\User;
use App\models\sales\Proforma;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class ProformaPolicy
{
    use HandlesAuthorization;
    /**
     * Class constructor.
     */
    public function __construct(User $user, Proforma $proforma)
    {
    }

    /**
     * Determine whether the user can view any proformas.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the proforma.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Proforma  $proforma
     * @return mixed
     */
    public function view(User $user, Proforma $proforma)
    {
        return $user->hasRole(Role::showProforma());
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::proforma());
    }

    /**
     * Determine whether the user can create proformas.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createProforma());
    }

    /**
     * Determine whether the user can update the proforma.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Proforma  $proforma
     * @return mixed
     */
    public function update(User $user, Proforma $proforma)
    {
        return $user->is($proforma->user);
    }



    /**
     * Determine whether the user can delete the proforma.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Proforma  $proforma
     * @return mixed
     */
    public function delete(User $user, Proforma $proforma)
    {
        //
    }

    /**
     * Determine whether the user can restore the proforma.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Proforma  $proforma
     * @return mixed
     */
    public function restore(User $user, Proforma $proforma)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the proforma.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Proforma  $proforma
     * @return mixed
     */
    public function forceDelete(User $user, Proforma $proforma)
    {
        //
    }
}
