<?php

namespace App\Policies\sales;

use App\models\users\Role;
use App\models\users\User;
use App\models\sales\Receipt;
use App\models\company\SystemFuncionality;
use Illuminate\Auth\Access\HandlesAuthorization;

class ReceiptPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any receipts.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the receipt.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Receipt  $receipt
     * @return mixed
     */
    public function view(User $user, Receipt $receipt)
    {
        //
    }

    public function funcionality(User $user)
    {
        return $user->company->hasFuncionality(SystemFuncionality::recipt());
    }

    /**
     * Determine whether the user can create receipts.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
        if (!$this->funcionality($user))
            return false;
        return $user->hasRole(Role::createReceipt());
    }

    /**
     * Determine whether the user can update the receipt.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Receipt  $receipt
     * @return mixed
     */
    public function update(User $user, Receipt $receipt)
    {
        return $user->is($receipt->user);
    }

    /**
     * Determine whether the user can delete the receipt.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Receipt  $receipt
     * @return mixed
     */
    public function delete(User $user, Receipt $receipt)
    {
        //
    }

    /**
     * Determine whether the user can restore the receipt.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Receipt  $receipt
     * @return mixed
     */
    public function restore(User $user, Receipt $receipt)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the receipt.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\sales\Receipt  $receipt
     * @return mixed
     */
    public function forceDelete(User $user, Receipt $receipt)
    {
        //
    }
}
