<?php

namespace App\Policies\shifts;

use App\models\users\Role;
use App\models\users\User;
use App\models\shifts\Shift;
use Illuminate\Auth\Access\HandlesAuthorization;

class ShiftPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any shifts.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        return $user->hasRole(Role::manageShifts());
    }

    /**
     * Determine whether the user can view the shift.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\shifts\Shift  $shift
     * @return mixed
     */
    public function view(User $user, Shift $shift)
    {
        //
        if (!$user->company->is($shift->company))
            return false;
        if ($user->can('manage-shifts'))
            return true;
        return $user->is($shift->user);
    }
    /**
     * Determine whether the user can update the shift.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\shifts\Shift  $shift
     * @return mixed
     */
    public function update(User $user, Shift $shift)
    {
        //
        if (!$user->company->is($shift->company))
            return false;
        if ($user->can('manage-shifts'))
            return true;
        return $user->is($shift->user);
    }
}
