<?php

namespace App\Policies\stock;

use App\models\stock\Category;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class CategoryPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any categories.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the category.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Category  $category
     * @return mixed
     */
    public function view(User $user, Category $category)
    {
        //
        return $user->company->is($category->company);

    }

    /**
     * Determine whether the user can create categories.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the category.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Category  $category
     * @return mixed
     */
    public function update(User $user, Category $category)
    {
        //
        return $user->company->is($category->company);

    }

    /**
     * Determine whether the user can delete the category.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Category  $category
     * @return mixed
     */
    public function delete(User $user, Category $category)
    {
        //
        return $user->company->is($category->company);

    }

    /**
     * Determine whether the user can restore the category.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Category  $category
     * @return mixed
     */
    public function restore(User $user, Category $category)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the category.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Category  $category
     * @return mixed
     */
    public function forceDelete(User $user, Category $category)
    {
        //
    }
}
