<?php

namespace App\Policies\stock;

use App\models\stock\Provider;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ProviderPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any providers.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the provider.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Provider  $provider
     * @return mixed
     */
    public function view(User $user, Provider $provider)
    {
        //
        return $user->company->is($provider->company);

    }

    /**
     * Determine whether the user can create providers.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the provider.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Provider  $provider
     * @return mixed
     */
    public function update(User $user, Provider $provider)
    {
        //
        return $user->company->is($provider->company);

    }

    /**
     * Determine whether the user can delete the provider.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Provider  $provider
     * @return mixed
     */
    public function delete(User $user, Provider $provider)
    {
        //
        return $user->company->is($provider->company);

    }

    /**
     * Determine whether the user can restore the provider.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Provider  $provider
     * @return mixed
     */
    public function restore(User $user, Provider $provider)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the provider.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Provider  $provider
     * @return mixed
     */
    public function forceDelete(User $user, Provider $provider)
    {
        //
    }
}
