<?php

namespace App\Policies\stock;

use App\models\stock\SaleUnit;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SaleUnitPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any sale units.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the sale unit.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\SaleUnit  $saleUnit
     * @return mixed
     */
    public function view(User $user, SaleUnit $saleUnit)
    {
        //
        return $user->company->is($saleUnit->company);

    }

    /**
     * Determine whether the user can create sale units.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the sale unit.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\SaleUnit  $saleUnit
     * @return mixed
     */
    public function update(User $user, SaleUnit $saleUnit)
    {
        //
        return $user->company->is($saleUnit->company);

    }

    /**
     * Determine whether the user can delete the sale unit.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\SaleUnit  $saleUnit
     * @return mixed
     */
    public function delete(User $user, SaleUnit $saleUnit)
    {
        //
        return $user->company->is($saleUnit->company);

    }

    /**
     * Determine whether the user can restore the sale unit.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\SaleUnit  $saleUnit
     * @return mixed
     */
    public function restore(User $user, SaleUnit $saleUnit)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the sale unit.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\SaleUnit  $saleUnit
     * @return mixed
     */
    public function forceDelete(User $user, SaleUnit $saleUnit)
    {
        //
    }
}
