<?php

namespace App\Policies\stock;

use App\models\stock\Saleable;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SaleablePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any saleables.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the saleable.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Saleable  $saleable
     * @return mixed
     */
    public function view(User $user, Saleable $saleable)
    {
        //
        return $user->company->is($saleable->company);
    }

    /**
     * Determine whether the user can create saleables.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the saleable.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Saleable  $saleable
     * @return mixed
     */
    public function update(User $user, Saleable $saleable)
    {
        return $user->company->is($saleable->company);
    }

    /**
     * Determine whether the user can delete the saleable.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Saleable  $saleable
     * @return mixed
     */
    public function delete(User $user, Saleable $saleable)
    {
        return $user->company->is($saleable->company);
    }

    /**
     * Determine whether the user can restore the saleable.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Saleable  $saleable
     * @return mixed
     */
    public function restore(User $user, Saleable $saleable)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the saleable.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Saleable  $saleable
     * @return mixed
     */
    public function forceDelete(User $user, Saleable $saleable)
    {
        //
    }
}
