<?php

namespace App\Policies\stock;

use App\models\stock\StockMove;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class StockMovePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any stock moves.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the stock move.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\StockMove  $stockMove
     * @return mixed
     */
    public function view(User $user, StockMove $stockMove)
    {
        //
        return $user->company->is($stockMove->company);

    }

    /**
     * Determine whether the user can create stock moves.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the stock move.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\StockMove  $stockMove
     * @return mixed
     */
    public function update(User $user, StockMove $stockMove)
    {
        //
        return $user->company->is($stockMove->company);

    }

    /**
     * Determine whether the user can delete the stock move.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\StockMove  $stockMove
     * @return mixed
     */
    public function delete(User $user, StockMove $stockMove)
    {
        //
        return $user->company->is($stockMove->company);

    }

    /**
     * Determine whether the user can restore the stock move.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\StockMove  $stockMove
     * @return mixed
     */
    public function restore(User $user, StockMove $stockMove)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the stock move.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\StockMove  $stockMove
     * @return mixed
     */
    public function forceDelete(User $user, StockMove $stockMove)
    {
        //
    }
}
