<?php

namespace App\Policies\stock;

use App\models\stock\Warehouse;
use App\models\users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class WarehousePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any warehouses.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        //
    }

    /**
     * Determine whether the user can view the warehouse.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Warehouse  $warehouse
     * @return mixed
     */
    public function view(User $user, Warehouse $warehouse)
    {
        return $user->company->is($warehouse->company);

    }

    /**
     * Determine whether the user can create warehouses.
     *
     * @param  \App\models\users\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the warehouse.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Warehouse  $warehouse
     * @return mixed
     */
    public function update(User $user, Warehouse $warehouse)
    {
        return $user->company->is($warehouse->company);
    }

    /**
     * Determine whether the user can delete the warehouse.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Warehouse  $warehouse
     * @return mixed
     */
    public function delete(User $user, Warehouse $warehouse)
    {
        //
        return $user->company->is($warehouse->company);

    }

    /**
     * Determine whether the user can restore the warehouse.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Warehouse  $warehouse
     * @return mixed
     */
    public function restore(User $user, Warehouse $warehouse)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the warehouse.
     *
     * @param  \App\models\users\User  $user
     * @param  \App\models\stock\Warehouse  $warehouse
     * @return mixed
     */
    public function forceDelete(User $user, Warehouse $warehouse)
    {
        //
    }
}
