<?php

namespace App\Providers;

use App\models\users\Role;
use App\models\sales\Basic;
use App\models\shifts\Shift;
use App\models\sales\Invoice;
use App\models\sales\Receipt;
use App\models\company\Brunch;
use App\models\sales\CashSale;
use App\models\sales\Proforma;
use App\models\stock\Category;
use App\models\stock\Provider;
use App\models\stock\Saleable;
use App\models\stock\SaleUnit;
use Laravel\Passport\Passport;
use App\models\sales\DebitNote;
use App\models\stock\StockMove;
use App\models\stock\Warehouse;
use App\models\provider\Expense;
use App\models\sales\CreditNote;
use App\models\provider\Purchase;
use App\models\customers\Customer;
use App\models\sales\DeliveryNote;
use App\Policies\sales\BasicPolicy;
use App\Policies\shifts\ShiftPolicy;
use Illuminate\Support\Facades\Gate;
use App\Policies\sales\InvoicePolicy;
use App\Policies\sales\ReceiptPolicy;
use App\Policies\sales\CashSalePolicy;
use App\Policies\sales\ProformaPolicy;
use App\Policies\stock\CategoryPolicy;
use App\Policies\stock\ProviderPolicy;
use App\Policies\stock\SaleablePolicy;
use App\Policies\stock\SaleUnitPolicy;
use App\Policies\sales\DebitNotePolicy;
use App\Policies\stock\StockMovePolicy;
use App\Policies\stock\WarehousePolicy;
use App\Policies\provider\ExpensePolicy;
use App\Policies\sales\CreditNotePolicy;
use App\Policies\provider\PurchasePolicy;
use App\Policies\customers\CustomerPolicy;
use App\Policies\sales\DeliveryNotePolicy;
use App\Policies\company\crm\CRMConfigurationPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        Basic::class    => BasicPolicy::class,
        CashSale::class => CashSalePolicy::class,
        Invoice::class  => InvoicePolicy::class,
        Receipt::class  => ReceiptPolicy::class,
        Proforma::class => ProformaPolicy::class,
        CreditNote::class   => CreditNotePolicy::class,
        DebitNote::class    => DebitNotePolicy::class,

        Shift::class    => ShiftPolicy::class,
        Saleable::class => SaleablePolicy::class,
        Provider::class => ProviderPolicy::class,
        Warehouse::class    => WarehousePolicy::class,
        Category::class     => CategoryPolicy::class,
        SaleUnit::class     => SaleUnitPolicy::class,
        StockMove::class    => StockMovePolicy::class,

        Customer::class => CustomerPolicy::class,

        Purchase::class => PurchasePolicy::class,

        Expense::class => ExpensePolicy::class,

        DeliveryNote::class => DeliveryNotePolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();
        Passport::routes();

        $this->salesGates();

        $this->shiftGates();

        $this->saleFunctionalities();






        Gate::define('check-company-full-reports', function ($user) {
            return $user->hasRole(Role::manageGlobal()) ? true : $user->hasRole(Role::manageLocal());
        });

        Gate::define('check-company-particular-reports', function ($user) {
            return $user->hasRole(Role::manageGlobal()) ? true : $user->hasRole(Role::manageLocal());
        });

        Gate::define('manage-stock', function ($user) {
            return $user->hasRole(Role::manageStock());
        });
        Gate::define('manage-customers', function ($user) {
            return $user->hasRole(Role::manageCustomers());
        });

        Gate::define('work-in', function ($user, Brunch $brunch) {
            return $user->company->is($brunch);
        });


        Gate::define('manage-users', function ($user, ?Brunch $brunch = null) {
            return $user->hasRole(Role::manageGlobal()) ? true : ($user->hasRole(Role::manageLocal()) and  $user->can('work-in', $brunch));
        });



        Gate::define('manage-brunch', function ($user, Brunch $brunch) {
            if (Gate::allows('manage-global')) {
                return true;
            }
            if (Gate::denies('manage-local')) {
                return false;
            }
            return $user->can('work-in', $brunch);
        });

        Gate::define('manage-global', function ($user) {
            return $user->hasRole(Role::manageGlobal());
        });

        Gate::define('manage-local', function ($user, Brunch $brunch = null) {
            return $user->hasRole(Role::manageLocal());
        });
    }

    private function saleFunctionalities()
    {
        Gate::define('funcionality-basicsale',     BasicPolicy::class . '@funcionality');
        Gate::define('funcionality-cashsale',      CashSalePolicy::class . '@funcionality');
        Gate::define('funcionality-invoice',       InvoicePolicy::class . '@funcionality');
        Gate::define('funcionality-creditnote',    CreditNotePolicy::class . '@funcionality');
        Gate::define('funcionality-debitnote',     DebitNotePolicy::class . '@funcionality');
        Gate::define('funcionality-recipt',        ReceiptPolicy::class . '@funcionality');
        Gate::define('funcionality-proforma',      ProformaPolicy::class . '@funcionality');
        Gate::define('funcionality-crm',           CRMConfigurationPolicy::class . '@funcionality');
    }

    private function salesGates()
    {
        Gate::define('issue-basicsale',     BasicPolicy::class . '@create');
        Gate::define('issue-or-return-basicsale',     BasicPolicy::class . '@returnOrCreate');
        Gate::define('issue-cashsale',      CashSalePolicy::class . '@create');
        Gate::define('issue-invoice',       InvoicePolicy::class . '@create');
        Gate::define('issue-creditnote',    CreditNotePolicy::class . '@create');
        Gate::define('issue-debitnote',     DebitNotePolicy::class . '@create');
        Gate::define('issue-recipt',        ReceiptPolicy::class . '@create');
        Gate::define('issue-proforma',      ProformaPolicy::class . '@create');
        Gate::define('issue-delivery_note',      DeliveryNotePolicy::class . '@create');


        Gate::define('issue-advanced-sales', function ($user) {
            if ($user->can('issue-proforma'))
                return true;
            if ($user->can('issue-cashsale'))
                return true;
            if ($user->can('issue-invoice'))
                return true;
            if ($user->can('issue-creditnote'))
                return true;
            if ($user->can('issue-debitnote'))
                return true;
            if ($user->can('issue-recipt'))
                return true;
            if ($user->can('issue-delivery_note'))
                return true;
            return false;
        });

        Gate::define('sale', function ($user) {
            return ($user->can('issue-advanced-sales') or
                $user->can('issue-basicsale'));
        });
    }


    private function shiftGates()
    {
        Gate::define('manage-shifts',     ShiftPolicy::class . '@viewAny');

        Gate::define('touch-shifts',  function ($user) {
            return ($user->can('manage-shifts') or
                $user->can('sale'));
        });
    }
}
