<?php

namespace App\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;



class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';

    /**
     * The path to the "home" route for your application.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        //

        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();

        $this->mapWebRoutes();

        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {
        Route::group([
            // 'middleware' => 'web',
            'prefix' => LaravelLocalization::setLocale(),
            'middleware' => ['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'],
            'namespace' => $this->namespace,
        ], function ($router) {
            require base_path('routes/web/web.php');
            require base_path('routes/web/company.php');
            require base_path('routes/web/customers.php');
            require base_path('routes/web/sales.php');
            require base_path('routes/web/shifts.php');
            require base_path('routes/web/stock.php');
            require base_path('routes/web/users.php');
        });
    }

    /**
     * Define the "api" routes for the appliWWWcation.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {

        Route::name('api.')->group(function () {
            Route::group([
                'middleware' => 'api',
                'prefix' => 'api',
                'namespace' => $this->namespace,
            ], function ($router) {
                require base_path('routes/api/api.php');
                require base_path('routes/api/company.php');
                require base_path('routes/api/customers.php');
                require base_path('routes/api/sales.php');
                require base_path('routes/api/shifts.php');
                require base_path('routes/api/stock.php');
                require base_path('routes/api/users.php');
            });
        });
    }
}
