<?php

namespace App\Traits;

use App\models\sales\Basic;
use App\models\shifts\Shift;
use App\models\sales\utils\PaymentMethod;

trait CreatesBasicSale
{
    public function createBasicSale(): Basic
    {

        $basic = $this->basicSales()->where('validated_at', null)->first();
        if ($basic){
            $shift = $this->currentShift();
            $basic->shift()->associate($shift);
            return $basic;
        }

        $paymentMethod = PaymentMethod::money();
        $shift = $this->currentShift();

        $basic = new Basic();
        $basic->paymentMethod()->associate($paymentMethod);
        $basic->shift()->associate($shift);
        $basic->save();
        return $basic;
    }

    public function basicSales()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->basicSales());
    }
}