<?php

namespace App\Traits;

use App\models\shifts\Shift;
use App\models\sales\CashSale;
use App\models\sales\utils\PaymentMethod;

trait CreatesCashSale
{
    public function createCashSale(): CashSale
    {

        $sale = $this->cashSales()->where('validated_at', null)->first();
        if ($sale) {
            $shift = $this->currentShift();
            $sale->shift()->associate($shift);
            return $sale;
        }
        $paymentMethod = PaymentMethod::money();
        $shift = $this->currentShift();

        $sale = new CashSale();
        $sale->paymentMethod()->associate($paymentMethod);
        $sale->shift()->associate($shift);
        $sale->save();
        return $sale;
    }

    public function cashSales()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->cashSales());
    }
}
