<?php

namespace App\Traits;

use App\models\sales\CreditNote;
use App\models\shifts\Shift;

trait CreatesCreditNote
{
    public function createCreditNote(): CreditNote
    {
        $note = $this->creditNotes()->where('validated_at', null)->first();
        if ($note){
            $shift = $this->currentShift();
            $note->shift()->associate($shift);
            return $note;
        }

        $shift = $this->currentShift();
        $note = new CreditNote();
        $note->shift()->associate($shift);
        $note->save();
        return $note;
    }


    public function creditNotes()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->creditNotes());
    }
}