<?php

namespace App\Traits;

use App\models\sales\DebitNote;
use App\models\shifts\Shift;

trait CreatesDebitNote
{
    public function createDebitNote(): DebitNote
    {
        $note = $this->debitNotes()->where('validated_at', null)->first();
        if ($note){
            $shift = $this->currentShift();
            $note->shift()->associate($shift);
            return $note;
        }

        $shift = $this->currentShift();
        $note = new DebitNote();
        $note->shift()->associate($shift);
        $note->save();
        return $note;
    }

    public function debitNotes()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->debitNotes());
    }
}