<?php

namespace App\Traits;

use App\models\shifts\Shift;
use App\models\sales\Invoice;
use App\models\sales\DeliveryNote;
use App\models\sales\InvoicesbyDelivery as invoiceDeliveryNotes;

trait CreatesInvoice
{
    public function createInvoice(): Invoice
    {
        $invoice = $this->invoices()->where('validated_at', null)->first();
        if ($invoice) {
            $shift = $this->currentShift();
            $invoice->shift()->associate($shift);
            return $invoice;
        }

        $shift = $this->currentShift();
        $invoice = new Invoice();
        $invoice->shift()->associate($shift);
        $invoice->save();
        return $invoice;
    }

    public function createInvoiceByDeliveryNotes(): invoiceDeliveryNotes
    {
        $invoice = $this->invoicesbydeliverynotes()->where('validated_at', null)->first();
        if ($invoice) {
            $shift = $this->currentShift();
            $invoice->shift()->associate($shift);
            return $invoice;
        }

        $shift = $this->currentShift();
        $invoice = new invoiceDeliveryNotes();
        $invoice->shift()->associate($shift);
        $invoice->save();
        return $invoice;
    }

    public function invoices()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->invoices());
    }

    public function invoicesbydeliverynotes()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->invoicesbydelivery());
    }


    public function createDeliveryNote(): DeliveryNote
    {
        $deliveryNote = $this->deliveryNotes()->where('validated_at', null)->first();
        if ($deliveryNote) {
            $shift = $this->currentShift();
            $deliveryNote->shift()->associate($shift);
            return $deliveryNote;
        }

        $shift = $this->currentShift();
        $deliveryNote = new DeliveryNote();
        $deliveryNote->shift()->associate($shift);
        $deliveryNote->save();
        return $deliveryNote;
    }

    public function deliveryNotes()
    {
        return $this->hasManyDeepFromRelations(
            $this->shifts(),
            (new Shift())->deliveryNotes()
        );
    }
}
