<?php

namespace App\Traits;

use App\models\shifts\Shift;
use App\models\sales\Proforma;

trait CreatesProforma
{
    //
    public function createProforma(): Proforma
    {

        $sale = $this->proformas()->where('validated_at', null)->first();
        if ($sale)
        {
            $shift = $this->currentShift();
            $sale->shift()->associate($shift);
            return $sale;
        }

        $shift = $this->currentShift();
        $sale = new Proforma();
        $sale->shift()->associate($shift);
        $sale->save();
        return $sale;
    }

    public function proformas()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->proformas());
    }
}