<?php

namespace App\Traits;

use App\models\shifts\Shift;
use App\models\sales\Receipt;

trait CreatesRecipts
{
    //

    public function createReceipt(): Receipt
    {
        $receipt = $this->receipts()->where('validated_at', null)->first();
        if ($receipt) {
            $shift = $this->currentShift();
            $receipt->shift()->associate($shift);
            return $receipt;
        }

        $shift = $this->currentShift();
        $receipt = new Receipt();
        $receipt->shift()->associate($shift);
        $receipt->save();
        return $receipt;
    }
    public function receipts()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->receipts());
    }
}
