<?php

namespace App\Traits\Customers;


use App\models\customers\CustomerOperation;

trait Billing
{
    //
    public function proformas()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->proforma());
    }

    public function creditNotes()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->creditNote());
    }

    public function debitNotes()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->debitNote());
    }

    public function invoices()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->invoice());
    }

    public function invoicesbydelivery()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->invoicebydelivery());
    }

    public function deliveryNotes()
    {
        return $this->hasManyDeepFromRelations(
            $this->customerOperations(),
            (new CustomerOperation())->deliveryNote()
        );
    }

    public function receipts()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->receipt());
    }

    public function basicSales()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->basicSale());
    }
    public function cashSales()
    {
        return $this->hasManyDeepFromRelations($this->customerOperations(), (new CustomerOperation())->cashSale());
    }


    public function getBills($amount)
    {
        $invoices = $this->invoices->filter(function ($item) {
            return $item->isPaid() ? false : true;
        });

        if ($amount <= 0)
            return $invoices;

        $invoices = $invoices->filter(function ($item) use (&$amount) {
            if ($amount <= 0)
                return false;
            $amount = $amount - $item->pendingAmount();
            return true;
        });
        return $invoices;
    }

    public function getBillsInvoiceByDelivery($amount)
    {
        $invoices = $this->invoicesbydelivery->filter(function ($item) {
            return $item->isPaid() ? false : true;
        });

        if ($amount <= 0)
            return $invoices;

        $invoices = $invoices->filter(function ($item) use (&$amount) {
            if ($amount <= 0)
                return false;
            $amount = $amount - $item->pendingAmount();
            return true;
        });
        return $invoices;
    }
}
