<?php

namespace App\Traits;

use App\models\sales\Receipt;
use App\models\stock\Provider;
use App\models\provider\PurchasePayment;
use App\models\provider\ProviderOperation;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

trait HasProviderOperation
{

    use HasRelationships;
    public function providerOperation()
    {
        return $this->belongsTo(ProviderOperation::class, 'provider_operations_id');
    }


    public function company()
    {
        return $this->hasOneDeepFromRelations($this->provider(), (new Provider())->company());
    }

    public function provider()
    {
        return $this->hasOneDeepFromRelations($this->providerOperation(), (new ProviderOperation())->provider());
    }

    public function pay($amount, Receipt $receipt = null, $reference = '')
    {
        $payment = new PurchasePayment();
        $payment->amount = $amount;

        if ($this->isPurchase())
            $payment->purchase()->associate($this);
        elseif ($this->isExpense())
            $payment->expense()->associate($this);
        else
            return;

        if ($receipt)
            $payment->receipt()->associate($receipt);

        $payment->reference = $reference;
        $payment->save();
        $payment->validate($this->provider);
    }

    public function validate(Provider $provider)
    {
        $providerOperation = new ProviderOperation();
        $providerOperation->validated_at = now();
        $providerOperation->provider()->associate($provider);
        $providerOperation->save();
        $this->providerOperation()->associate($providerOperation);
        $this->save();
        try {
            $this->validated_at = now();
            $this->save();
        } catch (\Exception $e) {
            // throw ;
        }
        return $this;
    }
    public function isPaid()
    {
        return ($this->pendingAmount() <= 0);
    }

    public function issueDate()
    {
        return $this->validated_at ? $this->validated_at->format('Y/m/d') : '';
    }

    public function isCancelled()
    {
        return !is_null($this->anuled_at);
    }

    /**
     * It has been validated
     * @return bool
     */
    public function isValidated(): bool
    {
        return !is_null($this->validated_at) ? true : false;
    }


    /**
     * It has been validated but not anulled
     * @return bool
     */
    public function isValid(): bool
    {
        return ($this->isValidated() and !$this->isCancelled());
    }

    public function isPurchase()
    {
        return false;
    }

    public function isExpense()
    {
        return false;
    }

    public function isPayment()
    {
        return false;
    }
}
