<?php

namespace App\Traits;

use App\models\shifts\Shift;

trait HasShifts
{
    //
    public function hasOpenShift(): bool{
        return $this->shifts()->where('ended_at', null)->exists();
    }

    public function shifts()
    {
        return $this->hasMany(Shift::class, 'users_id');
    }

    public function createShift()
    {
        $shift = new Shift();
        $shift->user()->associate($this);
        $shift->company()->associate($this->company);
        $shift->started_at = now();
        $shift->save();
        return $shift;
    }

    public function currentShift()
    {
        $shift  = $this->shifts()->where('ended_at', null)->first();
        return $shift ? $shift : $this->createShift();
    }


}