<?php

namespace App\Traits;

use App\models\stock\StockMove;
use App\models\stock\transference\StockTransferenceGroup;

trait ManagesStock
{
    public function stockMoves()
    {
        return $this->hasMany(StockMove::class, 'users_id');
    }

    public function transferGroups()
    {
        return $this->hasMany(StockTransferenceGroup::class, 'users_id');
    }

    public function activeTransferGroup()
    {
        $group = $this->transferGroups()->where('validated_at', null)->first();
        if ($group)
            return $group;

        $group = new StockTransferenceGroup();
        $group->user()->associate($this);
        $group->save();
        return $group;
    }
}
