<?php

namespace App\models\company;

use Carbon\Carbon;
use App\InvoicerModel;
use App\models\users\User;
use App\models\shifts\Shift;
use App\models\stock\Category;
use App\models\stock\Provider;
use App\models\stock\Saleable;
use App\models\stock\SaleUnit;
use App\models\stock\Warehouse;
use App\models\customers\Customer;
use App\models\company\BasicSaleOption;
use Illuminate\Support\Facades\Storage;
use App\models\company\CompanyVatScheme;
use App\models\company\SystemFuncionality;
use App\models\company\crm\CRMConfiguration;
use App\models\sales\relation\ItemSalableBasic;
use App\models\sales\relation\ItemSalableCashSale;
use App\models\sales\relation\ItemSalableDebitNote;
use App\models\sales\relation\ItemSalableDeliveryNote;
use App\models\sales\relation\ItemSaleableInvoiceByDelivery;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;
use App\models\sales\relation\ItemSalableInvoice;
use Illuminate\Support\Facades\DB;

class Brunch extends InvoicerModel
{
    //
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'brunch_company';
    protected $fillable =['stock_alert'];
    
    public static function table()
    {
        return 'brunch_company';
    }

    public function vatScheme()
    {
        return $this->belongsTo(CompanyVatScheme::class, 'vat_scheme_id');
    }

    public function funcionalities()
    {
        return $this->belongsToMany(SystemFuncionality::class, 'brunch_company_has_system_funcionalities', 'brunch_company_id', 'system_funcionalities_id');
    }

    public function hasFuncionality(SystemFuncionality $funcionality): bool
    {
        return $this->funcionalities()->where(SystemFuncionality::table() . '.id', $funcionality->id)->exists() ?  true : false;
    }

    public function hasFuncBasic_sale()
    {
        return $this->hasFuncionality(SystemFuncionality::basic_sale());
    }
    public function hasFuncInvoice()
    {
        return $this->hasFuncionality(SystemFuncionality::invoice());
    }
    public function hasFuncProforma()
    {
        return $this->hasFuncionality(SystemFuncionality::proforma());
    }
    public function hasFuncRecipt()
    {
        return $this->hasFuncionality(SystemFuncionality::recipt());
    }
    public function hasFuncDebit_note()
    {
        return $this->hasFuncionality(SystemFuncionality::debit_note());
    }
    public function hasFuncCredit_note()
    {
        return $this->hasFuncionality(SystemFuncionality::credit_note());
    }
    public function hasFuncCash_sale()
    {
        return $this->hasFuncionality(SystemFuncionality::cash_sale());
    }

    public function hasFuncDelivery_note()
    {
        return $this->hasFuncionality(SystemFuncionality::deliveryNote());
    }





    public function roles()
    {
        return $this->hasManyDeepFromRelations($this->funcionalities(), (new SystemFuncionality())->roles());
    }

    public function crmConfig()
    {
        return $this->hasOne(CRMConfiguration::class, 'brunch_company_id');
    }

    public function customers()
    {
        return $this->hasMany(Customer::class, 'brunch_company_id');
    }

    public function users()
    {
        return $this->hasMany(User::class, 'brunch_company_id');
    }

    public function activeUsers()
    {
        return $this->users()->wherehas('shifts', function ($query) {
            return $query->where('ended_at', null);
        });
    }



    public function saleables()
    {
        return $this->hasMany(Saleable::class, 'brunch_company_id');
    }
    public function saleUnits()
    {
        return $this->hasMany(SaleUnit::class, 'brunch_company_id');
    }
    public function providers()
    {
        return $this->hasMany(Provider::class, 'brunch_company_id');
    }
    public function warehouses()
    {
        return $this->hasMany(Warehouse::class, 'brunch_company_id');
    }

    public function saleWarehouse()
    {
        return $this->warehouses()->where('selling_werehouse', true)->first();
    }
    public function categories()
    {
        return $this->hasMany(Category::class, 'brunch_company_id');
    }

    public function stockMoves()
    {
        return $this->hasManyDeepFromRelations($this->users(), (new User)->stockMoves());
    }

    public function transferGroups()
    {
        return $this->hasManyDeepFromRelations($this->users(), (new User)->transferGroups());
    }



    public function basicSaleOption()
    {
        return $this->hasOne(BasicSaleOption::class, 'brunch_company_id');
    }

    /* Sales */
    public function shifts()
    {
        return $this->hasManyDeepFromRelations($this->users(), (new User())->shifts());
    }

    public function basicSales()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->basicSales());
    }
    public function cashSales()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->cashSales());
    }
    public function invoices()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->invoices());
    }

    public function invoicesbydelivery()  //nova
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->invoicesbydelivery());
    }

    public function receipts()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->receipts());
    }
    public function creditNotes()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->creditNotes());
    }
    public function debitNotes()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->debitNotes());
    }

    public function proformas()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->proformas());
    }
    public function deliveryNotes()
    {
        return $this->hasManyDeepFromRelations($this->shifts(), (new Shift())->deliveryNotes());
    }

    /* Sales */



    public function logoPhoto()
    {
        if (Storage::disk('public')->exists($this->logo)) {
            $file = $this->logo;
            $data = Storage::disk('public')->get($file);
        } else {
            $file = 'imgs/no-photo.jpg';
            $path = public_path($file);
            $data = file_get_contents($path); //This is an alternative to Storage::get('xyz) the contents of the file using native php function
        }

        $type = pathinfo($file, PATHINFO_EXTENSION);
        return 'data:image/' . $type . ';base64,' . base64_encode($data);
    }

    public function invoicesPeriod(Carbon $from, Carbon $to)
    {
        return $this->invoices()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to]);
    }

    public function invoicesByDeliveryNotesPeriod(Carbon $from, Carbon $to)
    {
        return $this->invoicesbydelivery()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to]);
    }



    public function deliveryNotesPeriod(Carbon $from, Carbon $to)
    {
        return $this->deliveryNotes()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to]);
    }

    public function basicSalesPeriod(Carbon $from, Carbon $to)
    {
        return $this->basicSales()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to])
            ->where('anuled_at',  null);
    }
    public function cashSalesPeriod(Carbon $from, Carbon $to)
    {
        return $this->cashSales()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to])
            ->where('anuled_at',  null);
    }
    public function receiptsPeriod(Carbon $from, Carbon $to)
    {
        return $this->receipts()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to]);
    }

    public function proformasPeriod(Carbon $from, Carbon $to)
    {
        return $this->proformas()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to]);
    }


    public function revenue(Carbon $from, Carbon $to)
    {
        $to = $to->endOfDay();
        $from = $from->startOfday();

        $basicSales = $this->basicSalesPeriod($from, $to)->get();
        $cashSales = $this->cashSalesPeriod($from, $to)->get();
        $receipts = $this->receiptsPeriod($from, $to)->get();

        return (sumSales($basicSales) +
            sumSales($cashSales) +
            sumSales($receipts));
    }

    public function revenueThisYear()
    {
        $from = (new Carbon())->startOfYear();
        $to = now();

        return $this->revenue($from, $to);
    }


    public function revenueThisMonth()
    {
        $from = (new Carbon())->startOfMonth();
        $to = now();
        return $this->revenue($from, $to);
    }

    public function runDefaults()
    {
        $customer = new Customer();
        $customer->code = getRandomString(5);
        $customer->name = "Cliente Interno";
        $customer->default = true;
        $customer->company()->associate($this);
        $customer->save();
    }



    // calculo das quantidades das vendas e o seus respeitovos repited $repitedItemsutos Facturas

    public function invoicesSalesItemsPeriod(Carbon $from, Carbon $to)
    {
        $invoices =  $this->invoices()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to])->get();


        $tempItems = collect([]);

         foreach ($invoices as $key => $invoice) {

             $saleItems = $invoice->saleItens()->get();

             foreach ($saleItems as $key => $item) {

                $tempItems->push( $item );

             }
         }




        //  pegando os codigos repitidos dos item de todas facturas;

        $filteredDuplicatedCode= $tempItems->duplicates('sale_code')->unique();
        $allItems = collect([]);

        foreach ($filteredDuplicatedCode as $key => $code) {

            $quantity = ItemSalableInvoice::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->sum('quantity');

            $repitedItems = ItemSalableInvoice::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->first();

            $total = ($repitedItems->unit_amount - $repitedItems->discount)  * $quantity;

            $allItems->push((object)[
                'sale_code'=>$repitedItems->sale_code,
                'sale_name'=>$repitedItems->sale_name,
                'saleable_id'=>$repitedItems->saleable_id,
                'unit_amount' => $repitedItems->unit_amount - $repitedItems->discount,
                'total'       => $total,
                'quantity'=>$quantity,
            ]);

        } //Pegando os que repetem e somando suas quantiades

         $normalItems = ItemSalableInvoice::whereBetween('created_at', [$from, $to])
         ->whereNotIn('sale_code',$filteredDuplicatedCode )->get();

        foreach ($normalItems as $key => $normalItem) {

            $total = ($normalItem->unit_amount - $normalItem->discount) * $normalItem->quantity;

            $allItems->push((object)[
                'sale_code'=>$normalItem->sale_code,
                'sale_name'=>$normalItem->sale_name,
                'saleable_id'=>$normalItem->saleable_id,
                'unit_amount' => $normalItem->unit_amount - $normalItem->discount,
                'total'   => $total,
                'quantity'=>$normalItem->quantity,
            ]);
        }




        return $allItems;
    }


    public function deliveryNotesItemsPeriod(Carbon $from, Carbon $to)
    {
        $deliverys =  $this->deliveryNotes()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to])->get();


        $tempItems = collect([]);

         foreach ($deliverys as $key => $invoice) {

             $saleItems = $invoice->saleItens()->get();

             foreach ($saleItems as $key => $item) {

                $tempItems->push( $item );

             }
         }




        //  pegando os codigos repitidos dos item de todas facturas;

        $filteredDuplicatedCode= $tempItems->duplicates('sale_code')->unique();
        $allItems = collect([]);

        foreach ($filteredDuplicatedCode as $key => $code) {

            $quantity = ItemSalableDeliveryNote::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->sum('quantity');

            $repitedItems = ItemSalableDeliveryNote::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->first();

            $total = ($repitedItems->unit_amount - $repitedItems->discount)  * $quantity;

            $allItems->push((object)[
                'sale_code'=>$repitedItems->sale_code,
                'sale_name'=>$repitedItems->sale_name,
                'saleable_id'=>$repitedItems->saleable_id,
                'unit_amount' => $repitedItems->unit_amount - $repitedItems->discount,
                'total'       => $total,
                'quantity'=>$quantity,
            ]);

        } //Pegando os que repetem e somando suas quantiades

         $normalItems =ItemSalableDeliveryNote::whereBetween('created_at', [$from, $to])
         ->whereNotIn('sale_code',$filteredDuplicatedCode )->get();

        foreach ($normalItems as $key => $normalItem) {

            $total = ($normalItem->unit_amount - $normalItem->discount) * $normalItem->quantity;

            $allItems->push((object)[
                'sale_code'=>$normalItem->sale_code,
                'sale_name'=>$normalItem->sale_name,
                'saleable_id'=>$normalItem->saleable_id,
                'unit_amount' => $normalItem->unit_amount - $normalItem->discount,
                'total'   => $total,
                'quantity'=>$normalItem->quantity,
            ]);
        }




        return $allItems;
    }

    public function basicsSalesItemsPeriod(Carbon $from, Carbon $to)
    {
        $basics =  $this->basicSales()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to])->get();


        $tempItems = collect([]);

         foreach ($basics as $key => $basic) {

             $saleItems = $basic->saleItens()->get();

             foreach ($saleItems as $key => $item) {

                $tempItems->push( $item );

             }
         }


        //  pegando os codigos repitidos dos item de todas facturas;

        $filteredDuplicatedCode= $tempItems->duplicates('sale_code')->unique();
        $allItems = collect([]);

        foreach ($filteredDuplicatedCode as $key => $code) {

            $quantity = ItemSalableBasic::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->sum('quantity');

            $repitedItems = ItemSalableBasic::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->first();

            $total = ($repitedItems->unit_amount - $repitedItems->discount)  * $quantity;

            $allItems->push((object)[
                'sale_code'=>$repitedItems->sale_code,
                'sale_name'=>$repitedItems->sale_name,
                'saleable_id'=>$repitedItems->saleable_id,
                'unit_amount' => $repitedItems->unit_amount - $repitedItems->discount,
                'total'       => $total,
                'quantity'=>$quantity,
            ]);

        } //Pegando os que repetem e somando suas quantiades

         $normalItems = ItemSalableBasic::whereBetween('created_at', [$from, $to])
         ->whereNotIn('sale_code',$filteredDuplicatedCode )->get();

        foreach ($normalItems as $key => $normalItem) {

            $total = ($normalItem->unit_amount-$normalItem->discount) * $normalItem->quantity;

            $allItems->push((object)[
                'sale_code'=>$normalItem->sale_code,
                'sale_name'=>$normalItem->sale_name,
                'saleable_id'=>$normalItem->saleable_id,
                'unit_amount' => $normalItem->unit_amount-$normalItem->discount,
                'total'   => $total,
                'quantity'=>$normalItem->quantity,
            ]);
        }




        return $allItems;
    }

    public function cashSalesItemsPeriod(Carbon $from, Carbon $to)
    {
        $basics =  $this->cashSales()->where('validated_at', '<>', null)
            ->whereBetween('validated_at', [$from, $to])->get();


        $tempItems = collect([]);

         foreach ($basics as $key => $basic) {

             $saleItems = $basic->saleItens()->get();

             foreach ($saleItems as $key => $item) {

                $tempItems->push( $item );

             }
         }


        //  pegando os codigos repitidos dos item de todas facturas;

        $filteredDuplicatedCode= $tempItems->duplicates('sale_code')->unique();
        $allItems = collect([]);

        foreach ($filteredDuplicatedCode as $key => $code) {

            $quantity = ItemSalableCashSale::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->sum('quantity');

            $repitedItems = ItemSalableCashSale::where('sale_code', $code)
            ->whereBetween('created_at', [$from, $to])->first();

            $total = ($repitedItems->unit_amount - $repitedItems->discount)  * $quantity;

            $allItems->push((object)[
                'sale_code'=>$repitedItems->sale_code,
                'sale_name'=>$repitedItems->sale_name,
                'saleable_id'=>$repitedItems->saleable_id,
                'unit_amount' => $repitedItems->unit_amount - $repitedItems->discount,
                'total'       => $total,
                'quantity'=>$quantity,
            ]);

        } //Pegando os que repetem e somando suas quantiades

         $normalItems = ItemSalableCashSale::whereBetween('created_at', [$from, $to])
         ->whereNotIn('sale_code',$filteredDuplicatedCode )->get();

        foreach ($normalItems as $key => $normalItem) {

            $total = ($normalItem->unit_amount - $normalItem->discount) * $normalItem->quantity;

            $allItems->push((object)[
                'sale_code'=>$normalItem->sale_code,
                'sale_name'=>$normalItem->sale_name,
                'saleable_id'=>$normalItem->saleable_id,
                'unit_amount' => $normalItem->unit_amount-$normalItem->discount,
                'total'   => $total,
                'quantity'=>$normalItem->quantity,
            ]);
        }




        return $allItems;
    }

    public function invoicesByDeliveryNotesItemsPeriod(Carbon $from, Carbon $to){

                    $invoices =  $this->invoicesbydelivery()->where('validated_at', '<>', null)
                    ->whereBetween('validated_at', [$from, $to])->get();


                $tempItems = collect([]);

                foreach ($invoices as $key => $invoice) {

                    $saleItems = $invoice->saleItens()->get();

                    foreach ($saleItems as $key => $item) {

                        $tempItems->push( $item );

                    }
                }




                //  pegando os codigos repitidos dos item de todas facturas;

                $filteredDuplicatedCode= $tempItems->duplicates('sale_code')->unique();
                $allItems = collect([]);

                foreach ($filteredDuplicatedCode as $key => $code) {

                    $quantity = ItemSaleableInvoiceByDelivery::where('sale_code', $code)
                    ->whereBetween('created_at', [$from, $to])->sum('quantity');

                    $repitedItems = ItemSaleableInvoiceByDelivery::where('sale_code', $code)
                    ->whereBetween('created_at', [$from, $to])->first();

                    $total = ($repitedItems->unit_amount - $repitedItems->discount)  * $quantity;

                    $allItems->push((object)[
                        'sale_code'=>$repitedItems->sale_code,
                        'sale_name'=>$repitedItems->sale_name,
                        'saleable_id'=>$repitedItems->saleable_id,
                        'unit_amount' => $repitedItems->unit_amount - $repitedItems->discount,
                        'total'       => $total,
                        'quantity'=>$quantity,
                    ]);

                } //Pegando os que repetem e somando suas quantiades

                $normalItems = ItemSaleableInvoiceByDelivery::whereBetween('created_at', [$from, $to])
                ->whereNotIn('sale_code',$filteredDuplicatedCode )->get();

                foreach ($normalItems as $key => $normalItem) {

                    $total = ($normalItem->unit_amount - $normalItem->discount) * $normalItem->quantity;

                    $allItems->push((object)[
                        'sale_code'=>$normalItem->sale_code,
                        'sale_name'=>$normalItem->sale_name,
                        'saleable_id'=>$normalItem->saleable_id,
                        'unit_amount' => $normalItem->unit_amount - $normalItem->discount,
                        'total'   => $total,
                        'quantity'=>$normalItem->quantity,
                    ]);
                }




                return $allItems;
    }

    public function getLastStock($id, $from, $to){ //periodicamente

        //verifcando o stock do produto somente em geradores;

        $onSotck = DB::table('stock_moves')->where('saleable_id', $id)
        ->whereBetween('validated_at', [$from, $to])
        ->latest('created_at')->first();

        $result = 0;

        if (!is_object($onSotck)) {
            $result = 0;
        } else {
            $balance = $onSotck->balance;
            $result = $balance;
        }


        return $result;
    }

    public function LastStock($id){

        //verifcando o stock do produto casos gerais;

        $onSotck = DB::table('stock_moves')->where('saleable_id', $id)
        ->latest('created_at')->first();

        $result = 0;

        if (!is_object($onSotck)) {
            $result = 0;
        } else {
            $balance = $onSotck->balance;
            $result = $balance;
        }


        return $result;
    }

}
