<?php

namespace App\models\company;

use App\InvoicerModel;
use App\models\company\Brunch;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyVatScheme extends InvoicerModel
{
    use SoftDeletes;

    protected $table = 'company_vat_scheme';

    public function brunchCompanies()
    {
        return $this->hasMany(Brunch::class, 'vat_scheme_id');
    }

    public static function scheme17(){
        return static::where('tax', 17)->first();
    }
    public static function scheme3(){
        return static::where('tax', 3)->first();
    }
}
