<?php

namespace App\models\company;

use App\InvoicerModel;
use App\models\users\Role;
use App\models\company\Brunch;

use Illuminate\Database\Eloquent\SoftDeletes;

class SystemFuncionality extends InvoicerModel
{
    //
    use SoftDeletes;

    protected $table = 'system_funcionalities';

    public static function table()
    {
        return 'system_funcionalities';
    }

    public function brunches()
    {
        return $this->belongsToMany(Brunch::class, 'brunch_company_has_system_funcionalities', 'system_funcionalities_id', 'brunch_company_id');
    }

    public function roles()
    {
        return $this->hasMany(Role::class, 'system_funcionalities_id');
    }


    public static function generic()
    {
        return static::where('slug', 'generic')->first();
    }

    public static function global_manager()
    {
        return static::where('slug', 'global_manager')->first();
    }

    public static function crm()
    {
        return static::where('slug', 'crm')->first();
    }
    public static function basic_sale()
    {
        return static::where('slug', 'basic_sale')->first();
    }
    public static function invoice()
    {
        return static::where('slug', 'invoice')->first();
    }


    public static function deliveryNote()
    {
        return static::where('slug', 'delivery-note')->first();
    }

    public static function proforma()
    {
        return static::where('slug', 'proforma')->first();
    }
    public static function recipt()
    {
        return static::where('slug', 'recipt')->first();
    }
    public static function debit_note()
    {
        return static::where('slug', 'debit_note')->first();
    }
    public static function credit_note()
    {
        return static::where('slug', 'credit_note')->first();
    }
    public static function cash_sale()
    {
        return static::where('slug', 'cash_sale')->first();
    }
}
