<?php

namespace App\models\company\crm;

use App\InvoicerModel;
use App\models\company\Brunch;
use Illuminate\Database\Eloquent\SoftDeletes;

class CRMConfiguration extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'crm_config';

    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }

    public function isEnabled()
    {
        return $this->enabled_at ? true : false;
    }

    public function getPoints(float $amount)
    {
        return ($amount / $this->increment_amount);
    }
    public function getAmount(float $points)
    {
        return ($points * $this->point_amount);
    }
}
