<?php

namespace App\models\company\customers\crm;

use App\InvoicerModel;
use App\models\sales\Basic;
use App\models\customers\Customer;

use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerPoint extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'customer_points';

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customers_id');
    }

    public function createdBy(){
        return $this->belongsTo(Basic::class, 'basic_created_id');
    }

    public function usedBy(){
        return $this->belongsTo(Basic::class, 'basic_used_by');
    }

}
