<?php

namespace App\models\customers;

use App\InvoicerModel;
use App\models\company\Brunch;
use App\Traits\Customers\Billing;
use App\Traits\Customers\Providers;
use App\models\sales\CustomerAdvance;
use App\models\customers\CustomerOperation;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\company\customers\crm\CustomerPoint;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Customer extends InvoicerModel
{
    use Billing;
    use Providers;
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'customers';

    public function    generateCode()
    {
        $this->code =  'C' . $this->company->id . 'CC' . ($this->company->customers()->where('created_at', '<', $this->created_at)->count() + 1);
        $this->save();
    }

    public function company()
    {
        return $this->belongsTo(Brunch::class, 'brunch_company_id');
    }

    public function customerOperations()
    {
        return $this->hasMany(CustomerOperation::class, 'customers_id');
    }

    public function customerAdvances()
    {
        return $this->hasMany(CustomerAdvance::class, 'customers_id');
    }

    public function customerPoints()
    {
        return $this->hasOne(CustomerPoint::class, 'customers_id');
    }

    public function unusedCustomerPoints()
    {
        return $this->customerPoints()->doesnthave('usedBy');
    }

    public function availableCRMPoints()
    {
        $crm = $this->company->crmConfig ?? null;
        if ($crm)
            return $this->unusedCustomerPoints()->sum('points');
        return 0;
    }
    public function availableCRMAmount()
    {
        return $this->unusedCustomerAmount();
    }


    public function unusedCustomerAmount()
    {
        $points = $this->unusedCustomerPoints()->sum('points');
        $crm = $this->company->crmConfig ?? null;
        if ($crm)
            return $crm->getAmount($points);
        return 0;
    }

    public function createOperation()
    {
        $operation = new CustomerOperation();
        $operation->customer()->associate($this);
        $operation->save();
        return $operation;
    }

    public function unusedAdvences()
    {
        return $this->customerAdvances()->where('used_at', null);
    }

    public function availableAdvanceAmount()
    {
        return $this->unusedAdvences()->sum('amount');
    }

    public function operationsBalance()
    {
        $operation = $this->customerOperations()
            ->orderBy('id', 'desc')
            ->first();
        return $operation ? $operation->postBalance() : 0;
    }

    public function balance()
    {
        return $this->availableAdvanceAmount() + $this->operationsBalance();
    }

    public function isDefault()
    {
        return $this->default;
    }

    public function haveCredit($data){

       return $data;

    }

}
