<?php

namespace App\models\customers;

use App\InvoicerModel;
use App\models\sales\Basic;
use App\models\sales\Invoice;
use App\models\sales\InvoicesbyDelivery;
use App\models\sales\Receipt;
use App\models\sales\CashSale;
use App\models\sales\Proforma;
use App\models\sales\DebitNote;
use App\models\sales\CreditNote;
use App\models\customers\Customer;
use App\models\sales\DeliveryNote;
use Illuminate\Support\Facades\URL;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerOperation extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'customer_operations';



    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customers_id');
    }

    public function preBalance()
    {
        $data = $this->customer->customerOperations()->where([
            ['id', '<', $this->id]
        ])
            ->orderBy('id', 'desc')
            ->take(1)->first();
        return $data ? $data->postBalance() : 0;
    }
    public function postBalance()
    {
        $data =  $this->customer->customerOperations()->where([
            ['id', '<=', $this->id],
        ])
            ->orderBy('id', 'asc')
            ->get();
        $debit = 0;
        $credit = 0;

        $data->each(function ($value, $key) use (&$credit, &$debit) {
            $debit = $debit + $value->creditAmount();
            $credit = $credit + $value->debitAmount();
        });

        return $debit - $credit;
    }

    public function creditAmount()
    {
        $amounts = [];
        array_push($amounts, $this->receipt     ?   $this->receipt->totalAmount()       : 0);
        array_push($amounts, $this->creditNote  ?   $this->creditNote->totalAmount()    : 0);
        array_push($amounts, $this->cashSale    ?   $this->cashSale->totalAmount()      : 0);
        return collect($amounts)->sum();
    }
    public function debitAmount()
    {
        $amounts = [];
        array_push($amounts, $this->debitNote   ? $this->debitNote->totalAmount()   : 0);
        array_push($amounts, $this->invoice     ? $this->invoice->totalAmount()     : 0);
        array_push($amounts, $this->cashSale    ? $this->cashSale->totalAmount()    : 0);
        array_push($amounts, $this->invoicebydelivery ? $this->invoicebydelivery->totalAmount() : 0);
        return collect($amounts)->sum();
    }

    public function name()
    {
        return ($this->proforma ? $this->proforma->name() : '') .
            ($this->creditNote ? $this->creditNote->name() : '') .
            ($this->debitNote ? $this->debitNote->name() : '') .
            ($this->invoice ? $this->invoice->code : '') .
            ($this->invoicebydelivery ? $this->invoicebydelivery->code : '').
            ($this->receipt ? $this->receipt->name() : '') .
            ($this->deliveryNote ? $this->deliveryNote->name() : '').
            ($this->cashSale ? $this->cashSale->name() : '');
    }

    public function type()
    {
        return ($this->proforma ? 'Proforma' : '') .
            ($this->creditNote ?  'creditNote' : '') .
            ($this->debitNote ?   'debitNote' : '') .
            ($this->invoice ?     'invoice' : '') .
            ($this->invoicebydelivery ? 'invoice' : '').
            ($this->receipt ?     'receipt' : '') .
            ($this->deliveryNote ?'deliveryNote' : '').
            ($this->cashSale ?    'cashSale' : '');
    }

    public function totalAmount()
     {
        return ($this->proforma ? $this->proforma->totalAmount() : '') .
            ($this->creditNote ? $this->creditNote->totalAmount() : '') .
            ($this->debitNote ? $this->debitNote->totalAmount() : '') .
            ($this->invoice ? $this->invoice->totalAmount() : '') .
            ($this->invoicebydelivery ? $this->invoicebydelivery->totalAmount() : '').
            ($this->receipt ? $this->receipt->totalAmount() : '') .
            ($this->deliveryNote ? $this->deliveryNote->totalAmount() : '').
            ($this->cashSale ? $this->cashSale->totalAmount() : '');
    }

    public function paidAmount()
    {
        return ($this->proforma ? 0 : '') .
            ($this->creditNote ? 0 : '') .
            ($this->debitNote ? number_format($this->debitNote->paidAmount() ): '') .
            ($this->invoice ? number_format($this->invoice->paidAmount()) : '') .
            ($this->invoicebydelivery ? number_format($this->invoicebydelivery->paidAmount()) : '').
            ($this->receipt ? 0 : '') .
            ($this->deliveryNote ? $this->deliveryNotePaidAmount(): '').
            ($this->cashSale ? 0 : '');
    }

    public function deliveryNotePaidAmount(){

        $invoice = $this->deliveryNote->invoices->first();

        if($invoice!=null){
            return $invoice->paidAmount();
        }


    }

    public function pendingAmount()
    {
        return ($this->proforma ? 0 : '') .
            ($this->creditNote ? 0: '') .
            ($this->debitNote ? number_format($this->debitNote->pendingAmount()) : '') .
            ($this->invoice ? $this->invoice->pendingAmount() : '') .
            ($this->invoicebydelivery ? $this->invoicebydelivery->pendingAmount() : '').
            ($this->receipt ? 0 : '') .
            ($this->deliveryNote ? 0: '').
            ($this->cashSale ? 0 : '');
    }

    public function webLink()
    {
        return ($this->proforma ? URL::signedRoute('web.sales.proforma.show', ['proforma' => $this->proforma->id]) : '') .
            ($this->creditNote ? URL::signedRoute('web.sales.creditnote.show', ['creditnote' => $this->creditNote->id]) : '') .
            ($this->debitNote ? URL::signedRoute('web.sales.debitnote.show', ['debitnote' => $this->debitNote->id]) : '') .
            ($this->invoice ? URL::signedRoute('web.sales.invoice.show', ['invoice' => $this->invoice->id]) : '') .
            ($this->invoicebydelivery ? URL::signedRoute('web.sales.invoices.show', ['invoice' => $this->invoicebydelivery->id]) : '') .
            ($this->receipt ? URL::signedRoute('web.sales.recipt.show', ['recipt' => $this->receipt->id]) : '') .
            ($this->cashSale ? URL::signedRoute('web.sales.cashsale.show', ['cashsale' => $this->cashSale->id]) : '').
            ($this->deliveryNote ? URL::signedRoute('web.sales.delivery_note.show', ['delivery_note'=>$this->deliveryNote->id]) : '');
    }

    public function proforma()
    {
        return $this->hasOne(Proforma::class, 'customer_operations_id');
    }

    public function creditNote()
    {
        return $this->hasOne(CreditNote::class, 'customer_operations_id');
    }
    public function deliveryNote()
    {
        return $this->hasOne(DeliveryNote::class, 'customer_operations_id');
    }

    public function debitNote()
    {
        return $this->hasOne(DebitNote::class, 'customer_operations_id');
    }

    public function invoice()
    {
        return $this->hasOne(Invoice::class, 'customer_operations_id');
    }

    public function invoicebydelivery()
    {
        return $this->hasOne(InvoicesbyDelivery::class, 'customer_operations_id');
    }

    public function receipt()
    {
        return $this->hasOne(Receipt::class, 'customer_operations_id');
    }

    public function basicSale()
    {
        return $this->hasOne(Basic::class, 'customer_operations_id');
    }
    public function cashSale()
    {
        return $this->hasOne(CashSale::class, 'customer_operations_id');
    }
}
