<?php

namespace App\models\provider;


use App\InvoicerModel;
use App\Traits\HasProviderOperation;
use App\models\provider\PurchasePayment;
use App\models\provider\ExpenseAttachment;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Expense extends   InvoicerModel
{
    use SoftDeletes;
    use HasRelationships;
    use HasProviderOperation;


    protected $table = 'expenses';

    public static function table()
    {
        return 'expenses';
    }

    public function payments()
    {
        return $this->hasMany(PurchasePayment::class, 'expenses_id');
    }


    public function attachments()
    {
        return $this->hasMany(ExpenseAttachment::class, 'expenses_id');
    }

    public function totalAmount()
    {
        return $this->amount;
    }

    public function totalAmountPaid()
    {
        return $this->payments->sum(function (PurchasePayment $item) {
            return $item->totalAmount();
        });
    }

    public function pendingAmount()
    {
        return $this->totalAmount() - $this->totalAmountPaid();
    }

   


    public function isExpense()
    {
        return true;
    }

}
