<?php
namespace App\models\provider;


use App\InvoicerModel;
use App\models\provider\Expense;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class ExpenseAttachment extends InvoicerModel
{
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'expenses_attachments';

    public static function table()
    {
        return 'expenses_attachments';
    }

    public function expense()
    {
        return $this->belongsTo(Expense::class, 'expenses_id');
    }

    public function uri(){
        return Storage::disk('public')->url($this->url);
    }
}