<?php

namespace App\models\provider;


use App\InvoicerModel;
use App\models\stock\Provider;
use App\models\provider\Expense;
use App\models\provider\Purchase;
use Illuminate\Support\Facades\URL;
use App\models\provider\PurchasePayment;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProviderOperation extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'provider_operations';

    public function provider()
    {
        return $this->belongsTo(Provider::class, 'providers_id');
    }

    public function expense()
    {
        return $this->hasOne(Expense::class, 'provider_operations_id');
    }

    public function purchase()
    {
        return $this->hasOne(Purchase::class, 'provider_operations_id');
    }

    public function payment()
    {
        return $this->hasOne(PurchasePayment::class, 'provider_operations_id');
    }

    public function reference()
    {
        if ($this->expense)
            return $this->expense->reference;
        if ($this->purchase)
            return $this->purchase->name;
        if ($this->payment)
            return $this->payment->reference;
    }
    public function isPaid()
    {
        if ($this->payment)
            return true;
        if ($this->expense)
            return $this->expense->isPaid();
        if ($this->purchase)
            return $this->purchase->isPaid();
    }


    public function credit()
    {
        if ($this->expense)
            return $this->expense->totalAmount();
        if ($this->purchase)
            return $this->purchase->totalAmount();
        return 0;
    }
    public function debit()
    {
        if ($this->payment)
            return $this->payment->totalAmount();
        return 0;
    }

    public function morth()
    {
        if ($this->expense)
            return $this->expense();
        if ($this->purchase)
            return $this->purchase();
        if ($this->payment)
            return $this->payment();
    }
    public function balance()
    {
        if ($this->expense)
            return $this->expense->reference;
        if ($this->purchase)
            return $this->purchase->name;
        if ($this->payment)
            return 'Pagamento';
    }

    public function preBalance()
    {
        $data = $this->provider->providerOperations()->where([
            ['id', '<', $this->id]
        ])
            ->orderBy('id', 'desc')
            ->take(1)->first();
        return $data ? $data->postBalance() : 0;
    }
    public function postBalance()
    {
        $data =  $this->provider->providerOperations()->where([
            ['id', '<=', $this->id],
        ])
            ->orderBy('id', 'asc')
            ->get();
        $debit = 0;
        $credit = 0;

        $data->each(function ($value, $key) use (&$credit, &$debit) {
            $debit = $debit + $value->credit();
            $credit = $credit + $value->debit();
        });

        return $debit - $credit;
    }

    public function webLink()
    {
        if ($this->expense)
            return URL::signedRoute('web.stock.providers.expenses.show', ['provider' => $this->provider->id, 'expense' => $this->expense->id]);
        if ($this->purchase)
            return URL::signedRoute('web.stock.providers.purchases.show', ['provider' => $this->provider->id, 'purchase' => $this->purchase->id]);
        return '#';
    }
}
