<?php

namespace App\models\provider;

use App\InvoicerModel;
use App\models\stock\StockMove;
use App\Traits\HasProviderOperation;
use App\models\provider\PurchasePayment;
use App\models\provider\PurchaseAttachment;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Purchase extends InvoicerModel
{
    use SoftDeletes;
    use HasProviderOperation;

    protected $table = 'purchases';

    public static function table()
    {
        return 'purchases';
    }

    public function stockMoves()
    {
        return $this->hasMany(StockMove::class, 'purchases_id');
    }

    public function payments()
    {
        return $this->hasMany(PurchasePayment::class, 'purchases_id');
    }

    public function attachments()
    {
        return $this->hasMany(PurchaseAttachment::class, 'purchases_id');
    }

    public function totalAmount()
    {
        return ($this->stockMoves->sum(function (StockMove $item) {
            return $item->totalAmount();
        }) - $this->financial_discount);
    }

    public function totalAmountPaid()
    {
        return $this->payments->sum(function (PurchasePayment $item) {
            return $item->totalAmount();
        });
    }

    public function pendingAmount()
    {
        return $this->totalAmount() - $this->totalAmountPaid();
    }

    public function validateMoves()
    {
        return $this->stockMoves->each(function (StockMove $item) {
            $item->validate();
        });
    }


    public function isPurchase()
    {
        return true;
    }
}
