<?php
namespace App\models\provider;


use App\InvoicerModel;
use App\models\provider\Purchase;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class PurchaseAttachment extends InvoicerModel
{
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'purchase_attachments';

    public static function table()
    {
        return 'purchase_attachments';
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class, 'purchases_id');
    }

    public function uri(){
        return Storage::disk('public')->url($this->url);
    }
}