<?php

namespace App\models\provider;


use App\InvoicerModel;
use App\models\sales\Receipt;
use App\models\provider\Expense;
use App\models\provider\Purchase;
use App\Traits\HasProviderOperation;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class PurchasePayment extends InvoicerModel
{
    use SoftDeletes;
    use HasRelationships;
    use HasProviderOperation;


    protected $table = 'purchase_payments';

    public static function table()
    {
        return 'purchase_payments';
    }

    public function expense()
    {
        return $this->belongsTo(Expense::class, 'expenses_id');
    }
    public function purchase()
    {
        return $this->belongsTo(Purchase::class, 'purchases_id');
    }
    public function receipt()
    {
        return $this->belongsTo(Receipt::class, 'recipts_id');
    }

    public function totalAmount()
    {
        return $this->amount;
    }


    public function isPayment(){
        return true;
    }
}
