<?php

namespace App\models\sales;

use App\models\sales\SaleModel;
use App\models\customers\Customer;
use App\models\sales\utils\PaymentMethod;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableBasic;
use App\models\company\customers\crm\CustomerPoint;

class Basic extends SaleModel
{
    use SoftDeletes;
    protected $table = 'basic_sales';

    public static function table()
    {
        return 'basic_sales';
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_methods_id');
    }
    public function saleItens()
    {
        return $this->hasMany(ItemSalableBasic::class, 'basic_sales_id');
    }


    public function name()
    {
        return 'BS.' . parent::name();
    }

    public function payViaCRM()
    {
    }

    public function generateCRM(Customer $customer, $amount)
    {
        $brunch = $this->company;
        $user = $this->user;

        if (!$user->can('funcionality-crm', $brunch))
            return;
        $crm =  $brunch->crmConfig ? $brunch->crmConfig : false;
        if (!$crm)
            return;

        if ($amount <= 0)
            return;

        $customerPoint = new CustomerPoint();
        $customerPoint->createdBy()->associate($this);
        $customerPoint->customer()->associate($customer);
        $customerPoint->points = $crm->getPoints($amount);
        $customerPoint->save();
    }
}
