<?php

namespace App\models\sales;

use App\models\sales\SaleModel;
use App\models\sales\utils\BankPayment;
use App\models\sales\utils\PaymentMethod;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableCashSale;

class CashSale extends SaleModel
{
    use SoftDeletes;
    protected $table = 'cash_sales';


    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_methods_id');
    }

    public function bankPayment()
    {
        return $this->belongsTo(BankPayment::class, 'bank_payments_id');
    }


    public function saleItens()
    {
        return $this->hasMany(ItemSalableCashSale::class, 'cash_sales_id');
    }

    public function name()
    {
        return 'VD.' . parent::name();
    }
}
