<?php

namespace App\models\sales;

use App\models\sales\Invoice;
use App\models\sales\SaleModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableCreditNote;

class CreditNote extends SaleModel
{
    use SoftDeletes;
    protected $table = 'credit_notes';

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoices_id');
    }

    public function saleItens()
    {
        return $this->hasMany(ItemSalableCreditNote::class, 'credit_notes_id');
    }


    public function name()
    {
        return 'NC.' . parent::name();
    }

    public function isCreditNote()
    {
        return true;
    }
}
