<?php

namespace App\models\sales;

use App\InvoicerModel;
use App\models\sales\Receipt;
use App\models\customers\Customer;
use App\models\sales\utils\AdvancePayment;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerAdvance extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'customer_advance';


    public function receipt()
    {
        return $this->belongsTo(Receipt::class, 'recipts_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customers_id');
    }

    public function advancePayment()
    {
        return $this->hasOne(AdvancePayment::class, 'customer_advance_id');
    }
}
