<?php

namespace App\models\sales;

use App\models\sales\Invoice;
use App\models\sales\SaleModel;
use App\models\sales\relation\ItemRecipt;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableDebitNote;

class DebitNote extends SaleModel
{
    use SoftDeletes;
    protected $table = 'debit_notes';




    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoices_id');
    }

    public function saleItens()
    {
        return $this->hasMany(ItemSalableDebitNote::class, 'debit_notes_id');
    }

    public function receiptItems()
    {
        return $this->hasMany(ItemRecipt::class, 'debit_notes_id');
    }

    public function vatResume()
    {
        return $this->saleItens->groupBy('vat_tax')->transform(function ($value, $key) {
            return (object) [
                'vat_tax'   => $key,
                'incidence' => $value->sum(function ($item) {
                    return ($item->totalAmount() - $item->taxAmount());
                }),
                'total'     =>  $value->sum(function ($item) {
                    return $item->taxAmount();
                }),
            ];
        });
    }

    public function groceriesAndServices()
    {
        return $this->saleItens->sum(function ($item) {
            return ($item->totalAmount() - $item->taxAmount());
        });
    }

    public function commercialDiscount()
    {
        return $this->saleItens->sum(function ($item) {
            return ($item->fullDiscount());
        });
    }


    public function paidAmount()
    {
        return $this->receiptItems()->whereHas('receipt', function ($query) {
            return $query->where([
                [Receipt::table() . '.anuled_at', null],
                [Receipt::table() . '.validated_at', '<>', null],

            ]);
        })->sum('amount');
    }


    public function pendingAmount()
    {
        return ($this->totalAmount() - $this->paidAmount());
    }




    public function isPaid(): bool
    {
        return $this->pendingAmount() <= 0;
    }

    public function isInvoice(){
        return false;
    }


    public function name()
    {
        return 'ND.' . parent::name();
    }
}
