<?php

namespace App\models\sales;

use App\models\sales\SaleModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableDeliveryNote;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class DeliveryNote extends SaleModel
{
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'delivery_notes';
    protected $fillable = ['invoiced'];

    public static function table(){
        return 'delivery_notes';
    }

    public function saleItens()
    {
        return $this->hasMany(ItemSalableDeliveryNote::class, 'delivery_notes_id');
    }


    public function isDeliveryNote()
    {
        return true;
    }

    public function name()
    {
        return 'GR.' . parent::name();
    }

    public function invoices()
    {
        return $this->belongsToMany(InvoicesbyDelivery::class, 'invoice_has_delivers', 'delivery_notes_id','invoicesbydelivery_id');
    }



}
























// public function canBepaid($amount)
//     {
//         if ($amount <= 0)
//             return false;
//         return (($this->pendingAmount() - $amount) <= 0);
//     }
