<?php

namespace App\models\sales;

use App\models\sales\DebitNote;
use App\models\sales\SaleModel;
use App\models\sales\CreditNote;
use App\models\sales\relation\ItemRecipt;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableInvoice;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Invoice extends SaleModel
{
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'invoices';
    public static function table(){
        return 'invoices';
    }

    public function saleItens()
    {
        return $this->hasMany(ItemSalableInvoice::class, 'invoices_id');
    }

    public function creditNotes()
    {
        return $this->hasMany(CreditNote::class, 'invoices_id');
    }
    public function debitNotes()
    {
        return $this->hasMany(DebitNote::class, 'invoices_id');
    }

    public function receipts()
    {
        return $this->hasManyDeepFromRelations($this->receiptItems(), (new ItemRecipt())->receipt());
    }

    public function receiptItems()
    {
        return $this->hasMany(ItemRecipt::class, 'invoices_id');
    }

    public function paidAmount()
    {
        return $this->receiptItems()->whereHas('receipt', function ($query) {
            return $query->where([
                [Receipt::table() . '.anuled_at', null],
                [Receipt::table() . '.validated_at', '<>', null],

            ]);
        })->sum('amount');
    }

    public function pendingAmount()
    {
        return ($this->totalAmount() - $this->paidAmount());
    }
    public function isPaid(): bool
    {
        return $this->pendingAmount() <= 0;
    }

    public function isInvoice()
    {
        return true;
    }

    public function name()
    {
        // return 'F.' . parent::name();
        return 'F';
    }
}
























// public function canBepaid($amount)
//     {
//         if ($amount <= 0)
//             return false;
//         return (($this->pendingAmount() - $amount) <= 0);
//     }
