<?php

namespace App\models\sales;

use App\models\sales\DebitNote;
use App\models\sales\SaleModel;
use App\models\sales\CreditNote;
use App\models\sales\relation\ItemRecipt;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableInvoice;
use App\models\sales\relation\ItemSaleableInvoiceByDelivery;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class InvoicesbyDelivery extends SaleModel
{
    // invoicesbydelivery

    use SoftDeletes;
    use HasRelationships;

    protected $table = 'invoicesbydelivery';
    public static function table(){
        return 'invoicesbydelivery';
    }

    public function saleItens()
    {
        return $this->hasMany(ItemSaleableInvoiceByDelivery::class, 'invoicesbydelivery_id');
    }

    public function creditNotes()
    {
        return $this->hasMany(CreditNote::class, 'invoicesbydelivery_id');
    }

    public function deliveryNotes(){

        return $this->belongsToMany(DeliveryNote::class, 'invoice_has_delivers', 'invoicesbydelivery_id', 'delivery_notes_id');
    }

    public function debitNotes()
    {
        return $this->hasMany(DebitNote::class, 'invoicesbydelivery_id');
    }

    public function receipts()
    {
        return $this->hasManyDeepFromRelations($this->receiptItems(), (new ItemRecipt())->receipt());
    }

    public function receiptItems()
    {
        return $this->hasMany(ItemRecipt::class, 'invoicesbydelivery_id');
    }

    public function paidAmount()
    {
        return $this->receiptItems()->whereHas('receipt', function ($query) {
            return $query->where([
                [Receipt::table() . '.anuled_at', null],
                [Receipt::table() . '.validated_at', '<>', null],

            ]);
        })->sum('amount');
    }

    public function pendingAmount()
    {
        return ($this->totalAmount() - $this->paidAmount());
    }
    public function isPaid(): bool
    {
        return $this->pendingAmount() <= 0;
    }

    public function isInvoice()
    {
        return true;
    }

    public function name()
    {
        // return 'F.' . parent::name();
        return 'FG';
    }
}
