<?php

namespace App\models\sales;

use App\models\sales\SaleModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\models\sales\relation\ItemSalableProforma;

class Proforma extends SaleModel
{
    use SoftDeletes;
    protected $table = 'proforma';

    public function saleItens()
    {
        return $this->hasMany(ItemSalableProforma::class, 'proforma_id');
    }

    public function name()
    {
        return 'P.' . parent::name();
    }

    public function isProforma(){
        return true;
    }
}
