<?php

namespace App\models\sales;

use App\models\sales\SaleModel;
use App\models\sales\CustomerAdvance;
use App\models\sales\utils\BankPayment;
use App\models\sales\relation\ItemRecipt;
use App\models\sales\utils\PaymentMethod;
use App\models\sales\utils\AdvancePayment;
use Illuminate\Database\Eloquent\SoftDeletes;
use Staudenmeir\EloquentHasManyDeep\HasRelationships;

class Receipt extends SaleModel
{
    use SoftDeletes;
    use HasRelationships;

    protected $table = 'recipts';

    public static function table()
    {
        return 'recipts';
    }



    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_methods_id');
    }
    public function bankPayment()
    {
        return $this->belongsTo(BankPayment::class, 'bank_payments_id');
    }

    public function advancePayment()
    {
        return $this->hasOne(AdvancePayment::class, 'recipts_id');
    }

    public function customerAdvance()
    {
        return $this->hasOne(CustomerAdvance::class, 'recipts_id');
    }

    public function recieptItems()
    {
        return $this->hasMany(ItemRecipt::class, 'recipts_id');
    }

    public function totalAmount()
    {
        return $this->recieptItems->sum(function ($item) {
            return $item->totalAmount();
        });
    }


    public function finalize($bills, $amount = 0)
    {
        $origialAmount = $amount;
        $total = $amount;
        foreach ($bills as $key => $bill) {

            $it = new ItemRecipt();
            $it->receipt()->associate($this);

            if ($bill->isInvoice()) {

                // $it->invoice()->associate($bill);

                if ($bill->name()=='FG') {
                   $it->invoicesbydelivery_id = $bill->id;
                }

                if ($bill->name()=='F') {
                    $it->invoices_id = $bill->id;
                 }

            } else {
                $it->debitNote()->associate($bill);
            }

            $pending = $bill->pendingAmount();
            if ($amount <= 0) {
                $it->amount  = $pending;
            } else if ($amount > $pending) {
                $it->amount = $pending;
                $amount = $amount - $pending;
            } else if ($amount <= $pending) {
                $it->amount = $amount;
                $amount = 0;
            }

            $it->pending = $pending - $it->amount;
            $it->save();
        }

        $customer = $bills->first()->customer;
        $this->validate($customer);

        $this->amount = ($total > 0) ? $total : $this->recieptItems()->sum('amount');
        $remaining = ($amount <= 0) ? 0 : $amount;
        $this->save();

        if ($this->paymentMethod->is(PaymentMethod::providerAdvance())) {
            $this->payPurchases($origialAmount);
        } else {
            $this->configureAdvance($remaining);
        }
    }

    public function payPurchases($amount)
    {
        $provider = $this->customer->provider;
        if ($provider) {
            $purchases = $provider->pendingPurchases();

            foreach ($purchases as $purchase) {
                $pending = $purchase->pendingAmount();

                if ($amount >= $pending) {
                    $purchase->pay($pending, $this);
                    $amount = $amount - $pending;
                } else if ($amount > 0) {
                    $purchase->pay($amount, $this);
                } else
                    break;
            }
        }
    }



    private function configureAdvance($amount)
    {

        if ($amount <= 0)
            return false;;

        $advance = new CustomerAdvance();
        $advance->customer()->associate($this->customer);
        $advance->receipt()->associate($this);
        $advance->amount = $amount;
        $advance->save();
    }


    public function name()
    {
        return 'R.' . parent::name();
    }

    public function isReceipt()
    {
        return true;
    }
}
