<?php

namespace App\models\sales\relation;

use App\InvoicerModel;
use App\models\stock\Warehouse;


class Addable extends InvoicerModel
{


    /* Full discount amount */
    public function taxAmount()
    {
        return $this->quantity * ($this->unit_amount - ($this->unit_amount / (1 + ($this->vat_tax / 100))));
    }

    public function fullDiscount()
    {
        return $this->quantity * $this->discount;
    }

    /* Total without discount */
    public function total()
    {
        return $this->quantity * $this->unit_amount;
    }

    /* Total with discount */
    public function totalAmount()
    {
        return $this->total() - $this->fullDiscount();
    }

    public function warehouse(){
        return $this->belongsTo(Warehouse::class, 'warehouses_id');
    }
}
