<?php

namespace App\models\sales\relation;

use App\InvoicerModel;
use App\models\sales\Invoice;
use App\models\sales\InvoicesbyDelivery;
use App\models\sales\Receipt;
use App\models\sales\DebitNote;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemRecipt extends InvoicerModel
{
    use SoftDeletes;
    protected $table = 'recipt_item';

    public function receipt()
    {
        return $this->belongsTo(Receipt::class, 'recipts_id');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoices_id');
    }

    public function invoicebydelivery()
    {
        return $this->belongsTo(InvoicesbyDelivery::class, 'invoicesbydelivery_id');
    }

    public function debitNote()
    {
        return $this->belongsTo(DebitNote::class, 'debit_notes_id');
    }


    public function total()
    {
        return $this->amount;
    }

    public function mutate()
    {
        return $this->invoice()->exists() ? $this->invoice : $this->debitNote;
    }

    public function mutatebydelivery()
    {
        return $this->invoicebydelivery()->exists() ? $this->invoicebydelivery : $this->debitNote;
    }

    /* Total with discount */
    public function totalAmount()
    {
        return $this->total();
    }

    public function name()
    {
        return$this->mutate()->name();
    }
}
