<?php

namespace App\models\sales\relation;

use App\models\sales\Basic;
use App\models\stock\Saleable;
use App\models\sales\relation\Addable;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSalableBasic extends Addable
{
    use SoftDeletes;
    protected $table = 'basic_sales_items';

    public function basic()
    {
        return $this->belongsTo(Basic::class, 'basic_sales_id');
    }

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }

}
