<?php

namespace App\models\sales\relation;

use App\models\sales\CashSale;
use App\models\stock\Saleable;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSalableCashSale extends Addable
{
    //
    use SoftDeletes;
    protected $table = 'cash_sale_items';

    public function cashsale()
    {
        return $this->belongsTo(CashSale::class, 'cash_sales_id');
    }

    public function saleable()
    {
        return $this->belongsTo(Saleable::class, 'saleable_id');
    }
}
